/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class VineBlockEntity
extends SyncedBlockEntity {
    public static final ModelProperty<Integer> AGE_PROPERTY = new ModelProperty();
    public static int MAX_AGE = 3;
    public static int MAX_DISTANCE = 7;
    private int age = 0;
    private int distance = 0;

    public VineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.VINE_TYPE.get(), pos, state);
    }

    public VineBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.age = tag.m_128451_("age");
        this.distance = tag.m_128451_("distance");
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(AGE_PROPERTY, (Object)this.getAge()).build();
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_("age", this.getAge());
        tag.m_128405_("distance", this.getDistance());
        super.m_183515_(tag);
    }

    public static int getMaxAge() {
        return MAX_AGE;
    }

    public static int getMaxDistance() {
        return MAX_DISTANCE;
    }

    public int getAge() {
        return this.age;
    }

    public int getDistance() {
        return this.f_58857_ != null ? this.distance : MAX_DISTANCE;
    }

    public void setAge(int age) {
        if (this.age != age) {
            this.age = age;
            this.inventoryChanged();
        }
    }

    public void setDistance(int distance) {
        if (this.distance != distance) {
            this.distance = distance;
            this.inventoryChanged();
        }
    }

    public void setAgeAndDistance(int age, int distance) {
        if (this.distance != distance || this.age != age) {
            this.distance = distance;
            this.age = age;
            this.inventoryChanged();
        }
    }
}

